fname = "hey.jsonl"
helper_program = f"""import fcntl, time
import json
import os

def is_file_locked(file_path):
    with open(file_path, 'r') as file:
        try:
            fcntl.flock(file.fileno(), fcntl.LOCK_EX | fcntl.LOCK_NB)
            return False  # File is not locked
        except IOError:
            return True # File is locked

fname = '{fname}'
while not os.path.exists(fname) or is_file_locked(fname):
    time.sleep(1)

actions = []
with open(fname, 'r') as f:
    for line in f:
        code = json.loads(line)
        if 'helper_program' in code:
            continue
        if 'transfomer' in code:
            continue
        actions.append(code)

with open(fname, 'w') as f:
    for action in actions:
        f.write(json.dumps(action) + '\\n')
"""
import subprocess
import os
import time
modify_f_script = "helper_.py"
with open(modify_f_script, "w") as f:
    f.write(helper_program)
p = subprocess.Popen(["python3", modify_f_script])
time.sleep(1)
os.system(f"rm {modify_f_script}")
